<?php
include_once("db.php");

// 1. Select ALL metrics needed for the score
$sql = "SELECT latitude, longitude, signal_dbm, download_speed, upload_speed, ping_ms FROM test_results";

$result = $conn->query($sql);
$response = array();

if ($result->num_rows > 0) {
    $points = array();
    while ($row = $result->fetch_assoc()) {
        $point = array();
        
        // 2. Parse numbers correctly
        $point['lat'] = floatval($row['latitude']);
        $point['lng'] = floatval($row['longitude']);
        $point['dbm'] = intval($row['signal_dbm']);
        $point['dl']  = floatval($row['download_speed']);
        $point['ul']  = floatval($row['upload_speed']);
        $point['ping'] = intval($row['ping_ms']);
        
        array_push($points, $point);
    }
    $response['status'] = 'success';
    $response['data'] = $points;
} else {
    $response['status'] = 'no_data';
}

echo json_encode($response);
?>